﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace DeX_Demo_Jun21
{
    public class ExportTool
    {
        public string PreHeader = "<?xml version=\"1.0\"?>";
        public string OuterTag = "<SuperStarReport-Enhanced>";
        public string HeaderSection = @"
  <RecordTypesToProcess>
    <RecordType>Pupil</RecordType>
  </RecordTypesToProcess>
  <ReportVersion>ESSDeX2021</ReportVersion>
";
        public XmlDocument GetFile(Dictionary<Guid, StudentRecord> Students)
        {
            StringBuilder b = new StringBuilder();
            b.AppendLine(PreHeader);
            b.AppendLine("<" + OuterTag + ">");
            foreach (StudentRecord s in Students.Values)
            {
                b.AppendLine(s.toXML());
            }
            b.AppendLine("</" + OuterTag + ">");
            XmlDocument d = new XmlDocument();
            d.InnerXml = b.ToString();
            return d;
        }
    }
}
/*
 <?xml version="1.0"?>
<SuperStarReport-Enhanced>
  <RecordTypesToProcess>
    <RecordType>Pupil</RecordType>
  </RecordTypesToProcess>
  <ReportVersion>ParentPay2020</ReportVersion>
  <Record>
    <RecordType>PUPIL</RecordType>
    <AdmissionNumber>001275</AdmissionNumber>
    <ChosenName>Daniel</ChosenName>
    <DateOfBirth>2009-01-12</DateOfBirth>
    <Diet>Vegetarian</Diet>
    <free_meal>F</free_meal>
    <Gender>M</Gender>
    <group_code>3</group_code>
    <HouseNumber>3</HouseNumber>
    <Meal>School Meal</Meal>
    <Postcode>PE4 7FQ</Postcode>
    <Salutation>Mr and Mrs Abdullah</Salutation>
    <Street>Penrith Grove</Street>
    <Surname>Trump</Surname>
    <Town>Peterborough</Town>
    <UPN>N823299911001</UPN>
    <FSMTransitionalProtection>F</FSMTransitionalProtection>
    <Telephones>
      <pupiltelephone>
        <main>T</main>
        <location>Home</location>
        <telephone>01632 367110</telephone>
      </pupiltelephone>
    </Telephones>
    <ContactList>
      <contact>
        <id>3118</id>
        <email>Abdullah@example.com</email>
        <mobile>
        </mobile>
        <telephone>01632 367110</telephone>
        <lastname>Abdullah</lastname>
        <firstname>Aneeta</firstname>
        <gender>
        </gender>
        <housenumber>3</housenumber>
        <street>Penrith Grove</street>
        <town>Peterborough</town>
        <county>
        </county>
        <postcode>PE4 7FQ</postcode>
        <workemail>
        </workemail>
        <salutation>Mrs Abdullah</salutation>
        <Priority>2</Priority>
      </contact>
      <contact>
        <id>3117</id>
        <email>Abdullah@example.com</email>
        <mobile>
        </mobile>
        <telephone>01632 367110</telephone>
        <lastname>Abdullah</lastname>
        <firstname>Usaf</firstname>
        <gender>
        </gender>
        <housenumber>3</housenumber>
        <street>Penrith Grove</street>
        <town>Peterborough</town>
        <county>
        </county>
        <postcode>PE4 7FQ</postcode>
        <workemail>
        </workemail>
        <salutation>Mr Abdullah</salutation>
        <Priority>1</Priority>
      </contact>
    </ContactList>
    <email_address>Abdullah@example.com</email_address>
    <Weekly_meal_pattern>School Meal (Mon), School Meal (Tue), School Meal (Wed), School Meal (Thu), School Meal (Fri)</Weekly_meal_pattern>
    <ID>3116</ID>
  </Record>
 */
